function Cin=pulseinject_metformin(t, tinject, Cinject)

% pulse for metformin injection, using 2 ml at 5 mM upstream of the pump


tpulse = [0 
    0.5
1
1.5
2
2.5
3
3.5
4
4.5
5
6
7
8
9
10
11
12
13
14
15
16
17
18
19
20
];


Cpulse = [0  
   0
4661.77
28837.20
28757.20
15340.73
10239.00
6683.79
4795.09
2604.19
1853.15
702.15
417.74
333.30
248.86
226.64
688.82
253.31
66.66
159.98
226.64
173.32
186.65
106.66
115.54
0];



TOTout = trapz(tpulse,Cpulse)*6e-3; % total pmol tracer output measured(flow rate is 6 ml/min)

Cpulseinj = Cinject*2e-3*Cpulse/TOTout; % 2 ml injected
% plot(tpulse,Cpulseinj)
% xlabel('time [min]')
% ylabel('concentration')

tp = t - tinject; % time form start of pulse
Cin = interp1(tpulse,Cpulseinj,tp);











